dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 6, 200, 250, "assets/images/table/island_6", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 6, 220, 400, "assets/images/table/island_6", "assets/images/food/item_mark2", "B" );

useFloAsServer = 0;
useWineTable = 1;
numMoodBoosts = 2;
numServers = 1;
maxCoupleHappiness = 400;

-- Group 1

guest = LManager.GenGuest(female02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = table2;
guest.percentRequestDrink = 40;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = male01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 6, 3000);


-- Group 2


guest = LManager.GenGuest(female04);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female03;
guest.percentRequestMusic = 80;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(7, 8, 28000);

-- Group 3

guest = LManager.GenGuest(female04);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = aunt;
guest.percentRequestCoffee = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = male01;
guest.percentRequestTissue = 50;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(9, 12, 55000);


-- Group 4

guest = LManager.GenGuest(male02);
guest.matchType = female04;
guest.percentRequestMusic = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = NOT_GUEST + male02;
guest.percentRequestDrink = 40;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(13, 14, 85000);

-- Group 5

guest = LManager.GenGuest(female02);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = male01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(15, 17, 100000);


-- Group 5

guest = LManager.GenGuest(female01);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(18, 20, 135000);

-- Group 6

guest = LManager.GenGuest(female03);
guest.matchType = aunt;
guest.percentRequestMusic = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female03;
guest.percentRequestDrink = 40;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = table2;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(21, 23, 150000);


LManager:AdjustGuestTolerance(130);

LManager:AddQuinnEvent( "fx/fx_bees.lua", 600, 300, 70000 );

LManager:SetLevelSetting ("dogDelay", 95000); 
LManager:SetLevelSetting ("dogChance", 100);

LManager:SetLevelSetting ("speakerDelay", 125000); 
LManager:SetLevelSetting ("speakerChance", 80);

-- Set up the Level Settings
LManager:SetLevelNumber(4,3);
LManager:SetLevelScores(9400, 13500);
LManager:SetLevelTime(300000);

LManager:SetMusic("assets/audio/music/Big Band 1.ogg","assets/audio/music/uptempo_2.ogg","assets/audio/music/uptempo_3.ogg");
LManager:SetBackgroundImage("assets/images/bg_island");
LManager:SetChairImage("assets/images/table/chair04");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );